# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import request_valid, stamp2datetime, interface_response, online_employee, \
    save_notification, remove_history, SUCCESS_CODE, MESSAGE_CODE, SYSTEM_EXCEPTION, DATA_EXCEPTION, \
    datetime2stamp, user_photo, paging
from django.utils.translation import ugettext_lazy as _
import json


class BioTimeAppManualLog(object):

    """
    【Manual Log】补签卡
    """

    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def category(self, source, device_token, language, token):
        """
        获取签卡事件
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code": 1, "error": "", "describe": "", "message": "", "data":["code": ID, "name":"名称"]}
            请求失败
                {"code": -10001, "error": "", "describe": "错误描述", "message": "弹窗信息", "data":""}
        """
        from mysite.att.att_param import get_func_key
        try:
            choices = get_func_key()
            data = [{'code': choice[0], 'name': choice[1]} for choice in choices]
            return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def work_code(self, source, device_token, language, token):
        """
        获取Workcode
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code": 1, "error": "", "describe": "", "message": "", "data":["code": ID, "name":"名称"]}
            请求失败
                {"code": -10001, "error": "", "describe": "错误描述", "message": "弹窗信息", "data":""}
        """
        from mysite.att.global_cache import CACHE_WORKCODE
        try:
            choices = CACHE_WORKCODE.get()
            return interface_response(SUCCESS_CODE, json.dumps(choices), '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(SUCCESS_CODE, '', '', e, SYSTEM_EXCEPTION)

    @request_valid
    @ladonize(long, str, int, str, int, str, str, str, rtype=str)
    def apply(self, punch_time, punch_type, work_code, remark, source, device_token, language, token):
        """
        补签卡申请
        @param punch_time:      签卡时间(stamp)
        @param punch_type:      签卡事件(数据获取调用 BioTimeAppManualLog -> category)
        @param work_code:       工作代码(数据获取调用 BioTimeAppManualLog -> work_code)
        @param remark:          备注
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":{"message":"弹窗信息"}}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.att.att_utils import department_approve, get_approver_flow, approve_flow
        from mysite.att import constant
        from mysite.att.models.checkexact_model import CheckExact
        from mysite.iclock.models.model_trans import Transaction
        from mysite.iclock.models.work_code import WorkCode
        import datetime
        check_time = stamp2datetime(punch_time)
        if check_time > datetime.datetime.now():
            error = u'Wrong Data'
            describe = u'{0}'.format(_(u'补签时间不能大于现在'))
            message = u'{0}'.format(_(u'补签时间不能大于现在'))
            return interface_response(MESSAGE_CODE, '', error, describe, message)
        emp = online_employee()
        ce = CheckExact.objects.filter(UserID=emp, CHECKTIME=check_time, audit_status=constant.AUDIT_SUCCESS)
        if ce:
            error = u'Wrong Data'
            describe = u'{0}'.format(_(u'补签记录输入重复'))
            return interface_response(-1, '', error, describe)
        trs = Transaction.objects.filter(PIN=emp.PIN, TTime=check_time).count()
        if trs > 0:
            error = u'Wrong Data'
            describe = u'{0}'.format(_(u'原始记录中已经有该记录'))
            message = u'{0}'.format(_(u'原始记录中已经有该记录'))
            return interface_response(MESSAGE_CODE, '', error, describe, message)
        if not punch_type:
            error = u'Wrong Data'
            describe = u'{0}'.format(_(u'请选择补签类型'))
            message = u'{0}'.format(_(u'请选择补签类型'))
            return interface_response(MESSAGE_CODE, '', error, describe, message)
        try:
            if work_code:
                wcs = WorkCode.objects.filter(id=work_code)
                if wcs:
                    work_code = wcs[0].code
                else:
                    describe = u'Work code not found'
                    message = _(u'Data Exception')
                    return interface_response(MESSAGE_CODE, '', '', describe, message)
            obj = CheckExact()
            obj.UserID = emp
            obj.CHECKTIME = check_time
            obj.YUYIN = u'{0}'.format(remark.decode('utf-8'))
            obj.CHECKTYPE = punch_type
            obj.work_code = work_code or ''
            obj.approve_level = 1
            obj.save()
            obj, approve_level = approve_flow(constant.CATEGORY_MANUAL, obj, emp, emp.PIN, '', None, None)
            obj.save()
            data = {
                'message': u'{0}'.format(_(u'Request already processing'))
            }
            return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

    @request_valid
    @ladonize(int, int, int, str, str, str, rtype=str)
    def my_application(self, approve_status, page_num, source, device_token, language, token):
        """
        获取自己的补签卡申请(申请,通过,拒绝)数据
        @param approve_status:  0:通过&拒绝, 1:申请, 2:通过，3：拒绝
        @param page_num:        页码（每页１５条数据）
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":""}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att import constant
        from mysite.att.att_param import get_func_key
        from mysite.iclock.models.model_notification import CATEGORY_MANUAL

        if approve_status in (0, 1, 2, 3):
            emp = online_employee()
            page_num = page_num or 1
            if not approve_status:
                _approve_status = ' audit_status in (2, 3) '
            else:
                _approve_status = ' audit_status in (%s) ' % approve_status
            sort_name = 'change_time'
            if approve_status in (1, ): #Apply
                sort_name = 'create_time'
            where = ' u.userid = %(applier)s and %(audit_status)s  ' % ({'applier': emp.pk, 'audit_status': _approve_status})
            try:
                sql = get_sql('sql', sqlid='manual_punch_application', app="pywebsv", params={'where': where, 'order_by': ''})
                sql = paging(sql, page_num, sort_name)
                rows = p_query(sql)
                data = {
                    'category': CATEGORY_MANUAL,
                    'items': []
                }
                if rows:
                    status = dict(constant.ALL_STATUS)
                    items = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                              'punch_time': datetime2stamp(r[3]), 'remark': r[5], 'category': get_func_key(r[4]),
                              'apply_time': datetime2stamp(r[6]), 'approve_status': r[7],
                              'approve_describe': u'{0}'.format(status.get(r[7], r[7])),
                              'approved_remark':r[9], 'approved_time': datetime2stamp(r[10])} for r in rows]
                    data['items'] = items
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'parameter approve_status={0} error'.format(approve_status)
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, int, int, str, str, str, rtype=str)
    def approval_list(self, approve_status, page_num, order_by, source, device_token, language, token):
        """
        获取审批列表
        @param approve_status:  0:通过&拒绝, 1:申请, 2:通过，3：拒绝
        @param page_num:        页码（每页１５条数据）
        @param order_by:        排序(1: 申请时间，２：审批时间), 申请界面默认为１，审批界面默认为２
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1, "error":"","describe":"","message":"","data":[{"code": ID,"pin":"人员工号","name":"名称","photo":"照片地址","punch_time":"签卡时间(stamp)","remark":"申请备注","category":"类型","apply_time":"申请时间","approve_status":"审核状态值","approve_describe":"审核状态","approved_remark":"审批备注", "approved_time":"审批时间"},]}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att import constant
        from mysite.att.att_param import get_func_key
        if approve_status in (0, 1, 2, 3):
            emp = online_employee()
            if not approve_status:
                _approve_status = ' audit_status in (%s, %s, %s) ' % (constant.AUDIT_SUCCESS, constant.REFUSE, constant.CANCEL_AUDIT_SUCCESS)
            elif approve_status in (constant.APPLICATION, ):
                _approve_status = ' audit_status in (%s, %s) ' % (constant.APPLICATION, constant.AUDITING)
            elif approve_status in (constant.REFUSE, ):
                _approve_status = ' audit_status in (%s, %s) ' % (constant.REFUSE, constant.CANCEL_AUDIT_SUCCESS)
            else:
                _approve_status = ' audit_status in (%s) ' % approve_status
            where = ' pdr.approver_id = %(approver)s and %(audit_status)s  ' % ({'approver': emp.pk, 'audit_status':_approve_status})
            # print "[*]Where:", where
            sort_name = 'change_time'
            if approve_status in (1, ): #Apply
                sort_name = 'create_time'
            page_num = page_num or 1
            try:
                sql = get_sql('sql', sqlid='manual_punch_application', app="pywebsv", params={'where': where})
                sql = paging(sql, page_num, sort_name)
                rows = p_query(sql)
                data = []
                if rows:
                    status = dict(constant.ALL_STATUS)
                    data = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                             'punch_time': datetime2stamp(r[3]),
                             'remark': r[5], 'category': get_func_key(r[4]), 'apply_time': datetime2stamp(r[6]),
                             'approve_status': r[7], 'approve_describe': u'{0}'.format(status.get(r[7], r[7])),
                             'approved_remark':r[9], 'approved_time': datetime2stamp(r[10])
                             } for r in rows]
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'Approve status not in (0,1,2,3)'
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, str, int, str, str, str, rtype=str)
    def approve(self, code, approve_status, remark, source, device_token, language, token):
        """
        补签卡审批
        @param code:                  对象ID
        @param approve_status:        审批状态(2:通过/3:拒绝)
        @param source:                数据来源(1: IOS， 2：Android)
        @param device_token:          消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":{"message":"弹窗信息"}}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.att.models.checkexact_model import CheckExact
        from mysite.att import constant
        from mysite.att.att_utils import approve_flow, save_history
        if code:
            if approve_status not in (constant.AUDIT_SUCCESS, constant.REFUSE):
                describe = 'param approve_status out of range'
                return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
            objs = CheckExact.objects.filter(id=code)
            if objs:
                try:
                    approver = online_employee()
                    obj = objs[0]
                    applier = obj.UserID
                    level = obj.approve_level
                    obj.audit_reason = u'{0}'.format(remark.decode('utf-8'))
                    obj.audit_user_id = approver.pk
                    approver_name = approver.EName or approver.PIN
                    obj, approve_level = approve_flow(constant.CATEGORY_MANUAL, obj, applier, applier.PIN, '', approver_name, approve_status)
                    obj.save()
                    approver = approver.PIN
                    save_history(constant.CATEGORY_MANUAL, obj.pk, level, approve_status, approver, approver_name, remark)
                    data = {
                        'message': u'{0}'.format(_(u'Approval Successful'))
                    }
                    return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
                except Exception, e:
                    import traceback
                    traceback.print_exc()
                    return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
            else:
                message = _(u'Data exception, please refresh')
                return interface_response(MESSAGE_CODE, '', '', 'Object Not Found', message)
        else:
            message = _(u'Data Exception')
            return interface_response(MESSAGE_CODE, '', '', 'Object Not Found', message)

    @request_valid
    @ladonize(int, int, str, str, str, rtype=str)
    def revoke(self, code, source, device_token, language, token):
        """
        补签卡申请撤销
        @param code:            对象ID
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":{"message":"弹窗信息"}}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.att.models.checkexact_model import CheckExact
        from mysite.att import constant
        from mysite.att.att_utils import approve_flow, save_history
        from mysite import const
        from mysite.iclock.models.model_trans import Transaction
        if code:
            approver = online_employee()
            objs = CheckExact.objects.filter(id=code)
            if objs:
                try:
                    obj = objs[0]
                    applier = obj.UserID
                    if obj.audit_status not in (constant.AUDIT_SUCCESS, ):
                        message = _(u'Not allowed')
                        return interface_response(MESSAGE_CODE, '', '', '', message)
                    obj.audit_status = constant.CANCEL_AUDIT_SUCCESS
                    obj.audit_user_id = applier.pk
                    obj.audit_reason = ''
                    super(CheckExact, obj).save()
                    objs = Transaction.objects.filter(PIN=obj.UserID.PIN, TTime=obj.CHECKTIME, data_source=const.MANUAL_LOG)
                    if objs:
                        objs.delete()
                    approve_level = obj.approve_level + 1
                    approver_name = approver.EName or approver.PIN
                    approver = approver.PIN
                    obj, approve_level = approve_flow(constant.CATEGORY_MANUAL, obj, applier, applier.PIN, '', approver_name, constant.CANCEL_AUDIT_SUCCESS)
                    obj.save()
                    save_history(constant.CATEGORY_MANUAL, obj.pk, approve_level, constant.CANCEL_AUDIT_SUCCESS, approver, approver_name, '')
                    data = {
                        'message': u'{0}'.format(_(u'OK'))
                    }
                    return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
                except Exception, e:
                    import traceback
                    traceback.print_exc()
                    return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
            else:
                message = _(u'Data Exception')
                return interface_response(MESSAGE_CODE, '', '', 'Object Not Found', message)
        else:
            message = _(u'Data Exception')
            return interface_response(MESSAGE_CODE, '', '', 'Object Not Found', message)